%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculation of the thermal conductivity of a two phase system           %
% Weighted geometric mean                                                 %
% Nelson Molina-Giraldo 2011                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function lm = Tcond_geometric(ls,lw,n)
lm = lw^n*ls.^(1-n);

% lm: thermal conductivity of the two phase system
% lw: thermal conductivity of the fluid phase
% ls: thermal conductivity of the solid phase
% n: porosity 